/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.toolbelt.belt;

import gigaherz.toolbelt.Config;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class ToolBeltInventory
implements IItemHandlerModifiable {
    private final ItemStack itemStack;

    ToolBeltInventory(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    private NBTTagCompound getTag() {
        NBTTagCompound tag = this.itemStack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            this.itemStack.func_77982_d(tag);
        }
        return tag;
    }

    public int getSlots() {
        return MathHelper.func_76125_a((int)this.getTag().func_74762_e("Size"), (int)2, (int)9);
    }

    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        NBTTagList tagList = this.getTag().func_150295_c("Items", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound itemTags = tagList.func_150305_b(i);
            if (itemTags.func_74762_e("Slot") != slot) continue;
            return new ItemStack(itemTags);
        }
        return ItemStack.field_190927_a;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        boolean hasStack;
        this.validateSlotIndex(slot);
        NBTTagCompound itemTag = null;
        boolean bl = hasStack = stack.func_190916_E() > 0;
        if (hasStack) {
            itemTag = new NBTTagCompound();
            itemTag.func_74768_a("Slot", slot);
            stack.func_77955_b(itemTag);
        }
        NBTTagList tagList = this.getTag().func_150295_c("Items", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound existing = tagList.func_150305_b(i);
            if (existing.func_74762_e("Slot") != slot) continue;
            if (hasStack) {
                tagList.func_150304_a(i, (NBTBase)itemTag);
            } else {
                tagList.func_74744_a(i);
            }
            return;
        }
        if (hasStack) {
            tagList.func_74742_a((NBTBase)itemTag);
        }
        this.getTag().func_74782_a("Items", (NBTBase)tagList);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (!this.canInsertItem(slot, stack)) {
            return stack;
        }
        if (stack.func_190916_E() <= 0) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.getStackInSlot(slot);
        int limit = stack.func_77976_d();
        if (existing.func_190916_E() > 0) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (existing.func_190916_E() <= 0) {
                existing = reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack;
            } else {
                existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
            }
            this.setStackInSlot(slot, existing);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
    }

    protected boolean canInsertItem(int slot, ItemStack stack) {
        return Config.isItemStackAllowed(stack);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.getStackInSlot(slot);
        if (existing.func_190916_E() <= 0) {
            return ItemStack.field_190927_a;
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.func_190916_E() <= toExtract) {
            if (!simulate) {
                this.setStackInSlot(slot, ItemStack.field_190927_a);
            }
            return existing;
        }
        if (!simulate) {
            this.setStackInSlot(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract)));
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    private void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.getSlots()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.getSlots() + ")");
        }
    }
}

